import argparse
from prompta.core.language import MinecraftSimpleLanguage
from prompta.utils.config_helper import read_config

def get_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--config', type=str, default=None)
    args = parser.parse_args()
    return args


if __name__ == '__main__':
    args = get_args()
    config = read_config(args.config)
    try:
        language = MinecraftSimpleLanguage(config)
        language.in_language(["minebirch_log"])
        language.env.close()
    except Exception as e:
        language.env.close()
        print(e.with_traceback())
        print(e.__traceback__)
        print(e)
